/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.DatData;
import gui.DictionaryData;
import gui.SpreadSheet;
import java.awt.Rectangle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CrossReferencer
extends Thread
implements ListSelectionListener {
    public SpreadSheet datSheet = null;
    public DatData datData = null;
    public SpreadSheet dicSheet = null;
    public DictionaryData dicData = null;
    boolean enabled = false;
    boolean block = false;
    boolean selectDic = false;
    boolean selectDat = false;
    boolean threadRunning = false;
    boolean killThread = false;
    public Object syncObj = new Object();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean en) {
        if (en) {
            this.datSheet.getSelectionModel().addListSelectionListener(this);
            this.dicSheet.getSelectionModel().addListSelectionListener(this);
        } else {
            this.datSheet.getSelectionModel().removeListSelectionListener(this);
            this.dicSheet.getSelectionModel().removeListSelectionListener(this);
        }
        this.enabled = en;
        this.block = false;
    }

    public void killThread() {
        this.killThread = true;
        this.notify();
    }

    public void run() {
        this.threadRunning = true;
        while (true) {
            try {
                this.syncObj.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.killThread) break;
            if (this.selectDic) {
                this.selectDic();
                this.selectDic = false;
            }
            if (!this.selectDat) continue;
            this.selectDat();
            this.selectDat = false;
        }
        this.threadRunning = false;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.enabled || this.block || this.datData == null) {
            return;
        }
        if (e.getSource() == this.datSheet.getSelectionModel()) {
            this.selectDic();
        } else {
            this.selectDat();
        }
    }

    public void selectDat() {
        this.block = true;
        this.datSheet.setColumnSelectionAllowed(false);
        this.datSheet.setRowSelectionAllowed(true);
        this.datSheet.clearSelection();
        int[] selDicRows = this.dicSheet.getSelectedRows();
        int showRow = -1;
        int i = 0;
        while (i < selDicRows.length) {
            DictionaryData.DicRow dicRow = (DictionaryData.DicRow)this.dicData.getRow(selDicRows[i]);
            int id = dicRow.getID();
            if (id != -1) {
                int datCount = 0;
                while (datCount < this.datData.getRowCount()) {
                    DatData.DataRow datRow = (DatData.DataRow)this.datData.getRow(datCount);
                    if (datRow.getID() == id) {
                        this.datSheet.addRowSelectionInterval(datCount, datCount);
                        if (showRow == -1 || datCount < showRow) {
                            showRow = datCount;
                        }
                    }
                    ++datCount;
                }
            }
            ++i;
        }
        if (showRow != -1) {
            Rectangle rect = this.datSheet.getCellRect(showRow, 0, false);
            this.datSheet.scrollRectToVisible(rect);
        }
        this.block = false;
    }

    public void selectDic() {
        this.block = true;
        this.dicSheet.setColumnSelectionAllowed(false);
        this.dicSheet.setRowSelectionAllowed(true);
        this.dicSheet.clearSelection();
        int[] selDatRows = this.datSheet.getSelectedRows();
        int showRow = -1;
        int i = 0;
        while (i < selDatRows.length) {
            DatData.DataRow datRow = (DatData.DataRow)this.datData.getRow(selDatRows[i]);
            int id = datRow.getID();
            if (id != -1) {
                int dicCount = 0;
                while (dicCount < this.dicData.getRowCount()) {
                    DictionaryData.DicRow dicRow = (DictionaryData.DicRow)this.dicData.getRow(dicCount);
                    if (dicRow.getID() == id) {
                        this.dicSheet.addRowSelectionInterval(dicCount, dicCount);
                        if (showRow == -1 || dicCount < showRow) {
                            showRow = dicCount;
                        }
                    }
                    ++dicCount;
                }
            }
            ++i;
        }
        if (showRow != -1) {
            Rectangle rect = this.dicSheet.getCellRect(showRow, 0, false);
            this.dicSheet.scrollRectToVisible(rect);
        }
        this.block = false;
    }
}

