/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CrossReferencer;
import gui.DatPage;
import gui.DictionaryCounter;
import gui.DictionaryPage;
import gui.Document;
import gui.DupeChecker;
import gui.ExtensionFileFilter;
import gui.HTMLViewerDialog;
import gui.ProjPage;
import gui.SecPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import loader.LoaderQSC;
import loader.LoaderRASC;
import loader.SaveCONOP;
import loader.SaveLST;
import loader.SaveQSC;
import loader.SaveRASC;

public class QSCreator
extends JFrame {
    JToolBar toolBar;
    JPanel mainView;
    JEditorPane htmlView;
    CardLayout mainViewLayout;
    JPanel pages;
    DatPage pageDat;
    DictionaryPage pageDic;
    SecPage pageSec;
    ProjPage pageProj;
    CrossReferencer crossRef = new CrossReferencer();
    Document doc;
    File fileChooserPath = null;
    QSCAction openAction = new QSCAction(this, "Open QSCreator...", null, "Open a QSCreator datafile.");
    QSCAction saveAction = new QSCAction(this, "Save QSCreator...", null, "Save to datafiles readable by QSCreator.");
    QSCAction openRASCAction = new QSCAction(this, "Open RASC...", null, "Load from datafiles.");
    QSCAction saveRASCAction = new QSCAction(this, "Save RASC...", null, "Save to datafiles readable by RASC.");
    QSCAction saveCONOPAction = new QSCAction(this, "Save CONOP...", null, "Save to datafiles readable by CONOP.");
    QSCAction saveLSTAction = new QSCAction(this, "Save List...", null, "Save to a human-readable summary file.");
    QSCAction exitAction = new QSCAction(this, "Exit", null, "Quit.");
    QSCAction crossRefAction = new QSCAction(this, "Enable Cross Referencing", null, "");
    QSCAction showHelpfileAction = new QSCAction(this, "Show help file", null, "");
    QSCAction ATUpdated = new QSCAction(this, "", null, "");
    static /* synthetic */ Class class$0;

    public QSCreator() {
        this.doc = new Document(this);
        this.setDefaultCloseOperation(3);
        this.setTitle("QSCreator");
        this.mainViewLayout = new CardLayout();
        this.mainView = new JPanel(this.mainViewLayout);
        this.mainView.add((Component)this.getIntroScreen(), "htmlView");
        this.pages = new JPanel();
        this.pageDat = new DatPage(this.doc);
        this.pageDic = new DictionaryPage(this.doc);
        this.pageSec = new SecPage(this.doc);
        this.pageProj = new ProjPage(this.doc);
        this.crossRef.datSheet = this.pageDat.spread;
        this.pageDat.crossRef = this.crossRef;
        this.crossRef.dicSheet = this.pageDic.spread;
        this.crossRef.dicData = this.doc.dic;
        this.doc.setDatPage(this.pageDat);
        JSplitPane rightSplit = new JSplitPane(0, this.pageDic, this.pageSec);
        JSplitPane splitPane = new JSplitPane(1, this.pageDat, rightSplit);
        this.mainView.add((Component)splitPane, "pages");
        this.mainViewLayout.show(this.mainView, "htmlView");
        this.add(this.mainView);
        this.addMenu();
        this.pack();
        this.setSize(1000, 700);
        splitPane.setDividerLocation(this.pageDat.getTableWidth() + 30);
        rightSplit.setDividerLocation(400);
        this.setVisible(true);
        DictionaryCounter counter = new DictionaryCounter(this.doc);
        counter.start();
    }

    public JPanel getIntroScreen() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel closePanel = new JPanel(new BorderLayout());
        JButton close = new JButton("Continue");
        closePanel.add((Component)close, "East");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                QSCreator.this.mainViewLayout.show(QSCreator.this.mainView, "pages");
            }
        });
        this.htmlView = new JEditorPane();
        this.htmlView.setEditable(false);
        this.htmlView.setContentType("text/html");
        try {
            this.htmlView.setPage(QSCreator.getURL("introscreen.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        panel.add((Component)new JScrollPane(this.htmlView), "Center");
        panel.add((Component)closePanel, "North");
        closePanel = new JPanel(new BorderLayout());
        close = new JButton("Continue");
        closePanel.add((Component)close, "East");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                QSCreator.this.mainViewLayout.show(QSCreator.this.mainView, "pages");
            }
        });
        panel.add((Component)closePanel, "South");
        return panel;
    }

    private void addMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(this.openAction);
        file.add(this.openRASCAction);
        file.addSeparator();
        file.add(this.saveAction);
        file.add(this.saveRASCAction);
        file.add(this.saveCONOPAction);
        file.add(this.saveLSTAction);
        file.addSeparator();
        file.add(this.exitAction);
        JMenu opt = new JMenu("Data");
        menuBar.add(opt);
        opt.add(this.crossRefAction);
        JMenu help = new JMenu("Help");
        menuBar.add(help);
        help.add(this.showHelpfileAction);
        this.setJMenuBar(menuBar);
    }

    public void actionPerformed(QSCAction e) throws Exception {
        if (e == this.openRASCAction) {
            this.openRASC();
        } else if (e == this.openAction) {
            this.openQSC();
        } else if (e == this.saveAction) {
            this.save();
        } else if (e == this.saveRASCAction) {
            this.saveRASC();
        } else if (e == this.saveCONOPAction) {
            this.saveCONOP();
        } else if (e == this.saveLSTAction) {
            this.saveLST();
        } else if (e == this.exitAction) {
            System.exit(1);
        } else if (e == this.ATUpdated) {
            if (this.pageDat != null) {
                this.pageDat.updatedAbundanceType();
            }
        } else if (e == this.crossRefAction) {
            this.crossRef.setEnabled(!this.crossRef.isEnabled());
            if (this.crossRef.isEnabled()) {
                this.crossRefAction.setText("Disable Cross Referencing");
            } else {
                this.crossRefAction.setText("Enable Cross Referencing");
            }
        } else if (e == this.showHelpfileAction) {
            HTMLViewerDialog viewer = new HTMLViewerDialog("QSCreator help", "QSCreator_help.txt", 800, 400, "text/plain");
            viewer.setVisible(true);
        }
    }

    public void openQSC() throws Exception {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("QSCreator files (*.qsc)");
        eff.addExtension("qsc", false);
        chooser.setFileFilter(eff);
        if (this.fileChooserPath != null) {
            chooser.setCurrentDirectory(this.fileChooserPath);
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            this.doc.clear();
            this.mainViewLayout.show(this.mainView, "pages");
            LoaderQSC.load(this.doc, chooser.getSelectedFile().getAbsolutePath());
            this.resetViews();
            this.setLoadedFile(chooser.getSelectedFile().getAbsolutePath());
        }
        this.fileChooserPath = chooser.getCurrentDirectory();
    }

    public void openRASC() throws Exception {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("DAT files (*.dat)");
        eff.addExtension("dat", false);
        chooser.setFileFilter(eff);
        if (this.fileChooserPath != null) {
            chooser.setCurrentDirectory(this.fileChooserPath);
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            this.doc.clear();
            this.mainViewLayout.show(this.mainView, "pages");
            LoaderRASC.load(this.doc, chooser.getSelectedFile().getAbsolutePath());
            this.resetViews();
            this.setLoadedFile(chooser.getSelectedFile().getAbsolutePath());
        }
        this.fileChooserPath = chooser.getCurrentDirectory();
    }

    public void save() throws Exception {
        if (DupeChecker.shouldSave(this.doc)) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            ExtensionFileFilter eff = new ExtensionFileFilter();
            eff.setDescription("QSCreator datafiles (*.qsc)");
            eff.addExtension("qsc", false);
            chooser.setFileFilter(eff);
            if (this.fileChooserPath != null) {
                chooser.setCurrentDirectory(this.fileChooserPath);
            }
            if ((returnVal = chooser.showSaveDialog(this)) == 0) {
                SaveQSC.saveQSC(this.doc, QSCreator.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "qsc"));
                this.setLoadedFile(chooser.getSelectedFile().getAbsolutePath());
            }
            this.fileChooserPath = chooser.getCurrentDirectory();
        }
    }

    public void saveRASC() throws Exception {
        if (DupeChecker.shouldSave(this.doc)) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            ExtensionFileFilter eff = new ExtensionFileFilter();
            eff.setDescription("DAT files (*.dat)");
            eff.addExtension("dat", false);
            chooser.setFileFilter(eff);
            if (this.fileChooserPath != null) {
                chooser.setCurrentDirectory(this.fileChooserPath);
            }
            if ((returnVal = chooser.showSaveDialog(this)) == 0 && SaveRASC.saveRASC(this.doc, QSCreator.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "DAT"))) {
                this.setLoadedFile(chooser.getSelectedFile().getAbsolutePath());
            }
            this.fileChooserPath = chooser.getCurrentDirectory();
        }
    }

    public void saveCONOP() throws Exception {
        if (DupeChecker.shouldSave(this.doc)) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            ExtensionFileFilter eff = new ExtensionFileFilter();
            eff.setDescription("DAT files (*.dat)");
            eff.addExtension("dat", false);
            chooser.setFileFilter(eff);
            if (this.fileChooserPath != null) {
                chooser.setCurrentDirectory(this.fileChooserPath);
            }
            if ((returnVal = chooser.showSaveDialog(this)) == 0) {
                SaveCONOP.saveCONOP(this.doc, QSCreator.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "DAT"));
            }
            this.fileChooserPath = chooser.getCurrentDirectory();
        }
    }

    public void saveLST() throws Exception {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("List files (*.lst)");
        eff.addExtension("lst", false);
        chooser.setFileFilter(eff);
        if (this.fileChooserPath != null) {
            chooser.setCurrentDirectory(this.fileChooserPath);
        }
        if ((returnVal = chooser.showSaveDialog(this)) == 0) {
            SaveLST.saveLST(this.doc, QSCreator.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "lst"));
        }
        this.fileChooserPath = chooser.getCurrentDirectory();
    }

    public void resetViews() {
        this.pageDat.updateUI();
        this.pageDic.updateUI();
        this.pageSec.updateUI();
        this.pageProj.updateUI();
    }

    public void setLoadedFile(String path) {
        this.setTitle("QSCreator - " + path);
    }

    public static URL getURL(String filename) {
        if (QSCreator.isJarred()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("gui.QSCreator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL url = clazz.getResource("/" + filename);
            return url;
        }
        try {
            File f = new File(filename);
            return f.toURI().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isJarred() {
        URL url;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gui.QSCreator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (url = clazz.getResource("/introscreen.html")) != null;
    }

    public static String appendExtension(String path, String ext) {
        if (path.regionMatches(true, path.length() - ext.length() - 1, "." + ext, 0, ext.length())) {
            return path;
        }
        return String.valueOf(path) + "." + ext;
    }

    public static Icon getImageIcon(String s) {
        return null;
    }

    public static void main(String[] args) {
        try {
            String nativeLF = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new QSCreator();
    }

    class QSCAction
    extends AbstractAction {
        QSCreator tsc;
        Object lock = null;

        public QSCAction(QSCreator tsc, String text, String iconFile, String description) {
            super(text, QSCreator.getImageIcon(iconFile));
            this.tsc = tsc;
            this.putValue("ShortDescription", description);
        }

        public QSCAction(QSCreator tsc, String text, String iconFile, String description, char accelerator) {
            this(tsc, text, iconFile, description);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)accelerator, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void useThread(Object lockObject) {
            this.lock = lockObject;
        }

        public void actionPerformed(ActionEvent e) {
            this.doAction();
        }

        public void doAction() {
            try {
                this.tsc.actionPerformed(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void setText(String t) {
            this.putValue("Name", t);
        }
    }
}

