/*
 * Decompiled with CFR 0.152.
 */
package loader;

import gui.DatData;
import gui.DictionaryData;
import gui.Document;
import gui.SecData;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LoaderQSC {
    public static void load(Document dataDoc, String filename) {
        Exception e = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            org.w3c.dom.Document xmlDoc = LoaderQSC.loadDoc(fis);
            LoaderQSC.readDoc(xmlDoc, dataDoc);
            fis.close();
        }
        catch (FileNotFoundException fnf) {
            e = fnf;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            e = x;
        }
        catch (ParserConfigurationException pce) {
            e = pce;
        }
        catch (IOException io) {
            e = io;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            Object[] options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There was an error loading the QSC file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
        }
    }

    public static org.w3c.dom.Document loadDoc(FileInputStream fis) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        org.w3c.dom.Document document = builder.parse(fis);
        return document;
    }

    public static void readDoc(org.w3c.dom.Document xmlDoc, Document dataDoc) {
        Element heading;
        Node node;
        NodeList nl = xmlDoc.getElementsByTagName("dictionary");
        int elementIndex = 0;
        while (elementIndex < nl.getLength()) {
            node = nl.item(elementIndex);
            if (node.getNodeType() == 1 && (heading = (Element)node).getTagName().compareToIgnoreCase("dictionary") == 0) {
                LoaderQSC.readDic(heading, dataDoc.dic);
                break;
            }
            ++elementIndex;
        }
        nl = xmlDoc.getElementsByTagName("sections");
        elementIndex = 0;
        while (elementIndex < nl.getLength()) {
            node = nl.item(elementIndex);
            if (node.getNodeType() == 1 && (heading = (Element)node).getTagName().compareToIgnoreCase("sections") == 0) {
                nl = xmlDoc.getElementsByTagName("section");
                elementIndex = 0;
                while (elementIndex < nl.getLength()) {
                    node = nl.item(elementIndex);
                    if (node.getNodeType() == 1 && (heading = (Element)node).getTagName().compareToIgnoreCase("section") == 0) {
                        LoaderQSC.readSection(heading, dataDoc.sec);
                    }
                    ++elementIndex;
                }
                break;
            }
            ++elementIndex;
        }
    }

    public static void readDic(Element dicE, DictionaryData dic) {
        NodeList nl = dicE.getChildNodes();
        int rowIndex = 0;
        int elementIndex = 0;
        while (elementIndex < nl.getLength()) {
            Element entry;
            Node node = nl.item(elementIndex);
            if (node.getNodeType() == 1 && (entry = (Element)node).getTagName().compareToIgnoreCase("entry") == 0) {
                String s;
                DictionaryData.DicRow row = new DictionaryData.DicRow();
                try {
                    s = entry.getAttribute("id");
                    row.setID(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                s = entry.getAttribute("name");
                row.setName(s);
                s = entry.getAttribute("nickname");
                row.setNickname(s);
                try {
                    s = entry.getAttribute("UE");
                    row.setUE(Boolean.parseBoolean(s));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    s = entry.getAttribute("MH");
                    row.setMH(Boolean.parseBoolean(s));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                s = entry.getAttribute("microfossilgroup");
                row.setMFG(s);
                s = entry.getAttribute("optional1");
                row.setOpt1(s);
                s = entry.getAttribute("optional2");
                row.setOpt2(s);
                dic.setRow(rowIndex++, row);
            }
            ++elementIndex;
        }
    }

    public static void readSection(Element section, SecData sec) {
        String s;
        SecData.SectionRow row = sec.createNewWell(false);
        try {
            row.setNickname(section.getAttribute("nickname"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            row.setName(section.getAttribute("name"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            row.setUnit(section.getAttribute("unit"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            s = section.getAttribute("waterdepth");
            row.setWaterDepth(Float.parseFloat(s));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            s = section.getAttribute("rottablheight");
            row.setHeightRotTabl(Float.parseFloat(s));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            s = section.getAttribute("abundancetype");
            row.setAT(s.charAt(0));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        row.datData.noEmptyRows = true;
        NodeList nl = section.getChildNodes();
        int elementIndex = 0;
        while (elementIndex < nl.getLength()) {
            Element event;
            Node node = nl.item(elementIndex);
            if (node.getNodeType() == 1 && (event = (Element)node).getTagName().compareToIgnoreCase("event") == 0) {
                LoaderQSC.readEvent(event, row.datData);
            }
            ++elementIndex;
        }
        row.datData.noEmptyRows = false;
    }

    public static void readEvent(Element event, DatData dat) {
        String s;
        DatData.DataRow row = new DatData.DataRow();
        try {
            s = event.getAttribute("id");
            row.setID(Integer.parseInt(s));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            s = event.getAttribute("depth");
            row.setDepth(Float.parseFloat(s));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            s = event.getAttribute("abundance");
            row.setAbundanceFloat(Float.parseFloat(s));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        row.setType(event.getAttribute("sampletype"));
        dat.addRow(row);
    }
}

