/*
 * Decompiled with CFR 0.152.
 */
package loader;

import gui.DatData;
import gui.DictionaryCounter;
import gui.DictionaryData;
import gui.Document;
import gui.SecData;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import loader.LoaderRASC;

public class SaveCONOP {
    public static void saveCONOP(Document doc, String filename) {
        Object[] options;
        OutputStreamWriter w;
        IDMap idMap = null;
        DictionaryCounter.count(doc);
        Exception e = null;
        try {
            FileOutputStream datOut = new FileOutputStream(LoaderRASC.changeExtension(filename, "DAT"));
            w = new OutputStreamWriter(datOut);
            idMap = SaveCONOP.saveDAT(doc, w);
            ((Writer)w).close();
            datOut.close();
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There was an error saving the DAT file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
        }
        e = null;
        try {
            FileOutputStream sctOut = new FileOutputStream(LoaderRASC.changeExtension(filename, "SCT"));
            w = new OutputStreamWriter(sctOut);
            SaveCONOP.saveSCT(doc, w);
            ((Writer)w).close();
            sctOut.close();
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There was an error saving the SCT file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
        }
        e = null;
        if (idMap != null) {
            try {
                FileOutputStream evtOut = new FileOutputStream(LoaderRASC.changeExtension(filename, "EVT"));
                w = new OutputStreamWriter(evtOut);
                SaveCONOP.saveEVT(doc, w, idMap);
                ((Writer)w).close();
                evtOut.close();
            }
            catch (FileNotFoundException ex) {
                e = ex;
            }
            catch (IOException ex) {
                e = ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            if (e != null) {
                options = new String[]{"OK"};
                JOptionPane.showOptionDialog(null, "There was an error saving the EVT file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
            }
        }
    }

    public static IDMap saveDAT(Document doc, Writer out) throws IOException {
        Vector<DATRecord> saveData = new Vector<DATRecord>();
        Iterator secIter = doc.sec.iterator();
        IDMap idMap = new IDMap();
        int secCount = 1;
        while (secIter.hasNext()) {
            DATRecord rec;
            SecData.SectionRow section = (SecData.SectionRow)secIter.next();
            Iterator dataIter = section.datData.iterator();
            int levelCount = 1;
            float lastDepth = 0.0f;
            int mul = -1;
            boolean reverseLevels = true;
            DATRecord first = null;
            DATRecord second = null;
            Vector<DATRecord> redoneData = new Vector<DATRecord>(section.datData.getRowCount());
            while (dataIter.hasNext()) {
                DatData.DataRow data = (DatData.DataRow)dataIter.next();
                if (data.isIncomplete()) continue;
                rec = new DATRecord();
                rec.id = data.getID();
                rec.section = secCount;
                rec.depth = data.getBuddy() ? lastDepth : (lastDepth = data.getDepth());
                DictionaryData.DicRow dicRow = doc.dic.getRowByID(rec.id);
                if (dicRow == null || dicRow.getCount() < doc.wellCutoff && !dicRow.getUE()) continue;
                redoneData.add(rec);
                if (first == null) {
                    first = rec;
                    continue;
                }
                if (second != null || first.depth == lastDepth) continue;
                second = rec;
            }
            if (first != null && second != null) {
                mul = second.depth > first.depth ? -1 : 1;
            }
            levelCount = !reverseLevels ? 1 : redoneData.size();
            Iterator redoneDataIter = redoneData.iterator();
            while (redoneDataIter.hasNext()) {
                rec = (DATRecord)redoneDataIter.next();
                rec.id = idMap.mapID(rec.id);
                rec.depth = (float)mul * rec.depth;
                rec.level = !reverseLevels ? levelCount++ : levelCount--;
                saveData.add(rec);
            }
            ++secCount;
        }
        Collections.sort(saveData);
        Iterator iter = saveData.iterator();
        while (iter.hasNext()) {
            DATRecord rec = (DATRecord)iter.next();
            out.write(String.valueOf(rec.toString()) + "\r\n");
        }
        return idMap;
    }

    public static void saveSCT(Document doc, Writer out) throws IOException {
        Iterator secIter = doc.sec.iterator();
        int i = 1;
        while (secIter.hasNext()) {
            SecData.SectionRow section = (SecData.SectionRow)secIter.next();
            String name = section.getName();
            String nick = section.getNickname();
            if (nick == null) {
                nick = " ";
            }
            out.write(String.valueOf(SaveCONOP.fillSpace("" + i, 2)) + " '" + nick + "' " + SaveCONOP.fillSpace("" + i, 2) + " '" + name + "' 1");
            if (secIter.hasNext()) {
                out.write("\r\n");
            }
            ++i;
        }
    }

    public static void saveEVT(Document doc, Writer out, IDMap idMap) throws IOException {
        DictionaryData.DicRow row;
        Iterator dicIter = doc.dic.iterator();
        Vector<DictionaryData.DicRow> saveData = new Vector<DictionaryData.DicRow>(998);
        while (dicIter.hasNext()) {
            row = (DictionaryData.DicRow)dicIter.next();
            if (!idMap.isMapped(row.getID())) continue;
            row = new DictionaryData.DicRow(row);
            row.setID(idMap.mapID(row.getID()));
            saveData.add(row);
        }
        Collections.sort(saveData, new DicRowComparator());
        dicIter = saveData.iterator();
        while (dicIter.hasNext()) {
            String nick;
            row = (DictionaryData.DicRow)dicIter.next();
            if (row.getID() == -1 || row.getName().length() < 1) continue;
            String name = row.getName();
            if (name.length() > 40) {
                name = name.substring(0, 40);
            }
            if ((nick = row.getNickname()) == null || nick.length() == 0) {
                nick = SaveCONOP.fillZeros("" + row.getID(), 3);
            }
            out.write(String.valueOf(SaveCONOP.fillSpace("" + row.getID(), 3)) + " '" + nick + "' '" + name + "'\r\n");
        }
    }

    public static String fillSpace(String s, int width) {
        String ret = s;
        while (ret.length() < width) {
            ret = " " + ret;
        }
        return ret;
    }

    public static String fillZeros(String s, int width) {
        String ret = s;
        while (ret.length() < width) {
            ret = "0" + ret;
        }
        return ret;
    }

    public static String formatFloat(float f, int fracDigits) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(fracDigits);
        nf.setGroupingUsed(false);
        String s = nf.format(f);
        return s;
    }

    public static class DATRecord
    implements Comparable {
        public int id;
        public int origID;
        public int section;
        public float depth;
        public int level;

        public String toString() {
            return this.id + " -3 " + this.section + " " + SaveCONOP.formatFloat(this.depth, 1) + " " + this.level + " 3 1 1";
        }

        public int compareTo(Object arg) {
            if (!(arg instanceof DATRecord)) {
                return 0;
            }
            DATRecord other = (DATRecord)arg;
            if (this.id != other.id) {
                return this.id - other.id;
            }
            if (this.section != other.section) {
                return this.section - other.section;
            }
            float ret = this.depth - other.depth;
            if (ret < 0.0f) {
                return -1;
            }
            if (ret > 0.0f) {
                return 1;
            }
            return 0;
        }
    }

    public static class DicRowComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            if (!(arg0 instanceof DictionaryData.DicRow) || !(arg1 instanceof DictionaryData.DicRow)) {
                return 0;
            }
            DictionaryData.DicRow left = (DictionaryData.DicRow)arg0;
            DictionaryData.DicRow right = (DictionaryData.DicRow)arg1;
            return left.getID() - right.getID();
        }
    }

    public static class IDMap {
        Map idMap = new Hashtable();
        int idCounter = 1;

        public int mapID(int dataID) {
            Integer key = new Integer(dataID);
            if (this.idMap.containsKey(key)) {
                return (Integer)this.idMap.get(key);
            }
            this.idMap.put(key, new Integer(this.idCounter++));
            return this.idCounter - 1;
        }

        public boolean isMapped(int dataID) {
            return this.idMap.containsKey(new Integer(dataID));
        }
    }
}

