/*
 * Decompiled with CFR 0.152.
 */
package loader;

import gui.DatData;
import gui.DictionaryData;
import gui.Document;
import gui.SecData;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class SaveQSC {
    public static void saveQSC(Document dataDoc, String filename) {
        Exception e = null;
        try {
            FileOutputStream datOut = new FileOutputStream(filename);
            org.w3c.dom.Document doc = SaveQSC.setupDoc(dataDoc);
            SaveQSC.writeDoc(doc, datOut);
            datOut.close();
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (TransformerException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            Object[] options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There was an error saving the INP file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
        }
    }

    protected static org.w3c.dom.Document setupDoc(Document dataDoc) throws IOException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        org.w3c.dom.Document xmlDoc = builder.newDocument();
        Element root = xmlDoc.createElement("qscreator");
        xmlDoc.appendChild(root);
        Element dicE = xmlDoc.createElement("dictionary");
        SaveQSC.fillDic(dicE, dataDoc.dic);
        root.appendChild(dicE);
        Element secE = xmlDoc.createElement("sections");
        SaveQSC.fillSections(secE, dataDoc.sec);
        root.appendChild(secE);
        return xmlDoc;
    }

    public static void fillDic(Element e, DictionaryData dic) {
        Iterator dicIter = dic.iterator();
        while (dicIter.hasNext()) {
            DictionaryData.DicRow row = (DictionaryData.DicRow)dicIter.next();
            if (row.getID() == -1 || row.getName().length() < 1) continue;
            Element entry = e.getOwnerDocument().createElement("entry");
            entry.setAttribute("id", "" + row.getID());
            entry.setAttribute("name", row.getName());
            entry.setAttribute("nickname", row.getNickname());
            entry.setAttribute("UE", "" + row.getUE());
            entry.setAttribute("MH", "" + row.getMH());
            entry.setAttribute("microfossilgroup", row.getMFG());
            entry.setAttribute("optional1", row.getOpt1());
            entry.setAttribute("optional2", row.getOpt2());
            e.appendChild(entry);
        }
    }

    public static void fillSections(Element e, SecData sec) {
        Iterator secIter = sec.iterator();
        while (secIter.hasNext()) {
            SecData.SectionRow section = (SecData.SectionRow)secIter.next();
            Element sectionE = e.getOwnerDocument().createElement("section");
            sectionE.setAttribute("nickname", section.getNickname());
            sectionE.setAttribute("name", section.getName());
            sectionE.setAttribute("unit", section.getUnit());
            sectionE.setAttribute("waterdepth", "" + section.getWaterDepth());
            sectionE.setAttribute("rottablheight", "" + section.getHeightRotTabl());
            sectionE.setAttribute("abundancetype", section.getAT().toString());
            e.appendChild(sectionE);
            Iterator dataIter = section.datData.iterator();
            while (dataIter.hasNext()) {
                DatData.DataRow data = (DatData.DataRow)dataIter.next();
                Element event = e.getOwnerDocument().createElement("event");
                event.setAttribute("id", "" + data.getID());
                event.setAttribute("depth", "" + data.getDepth());
                event.setAttribute("abundance", "" + data.getAbundanceFloat());
                event.setAttribute("sampletype", data.getType());
                sectionE.appendChild(event);
            }
        }
    }

    protected static void writeDoc(org.w3c.dom.Document doc, OutputStream out) throws TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
    }
}

