/*
 * Decompiled with CFR 0.152.
 */
package loader;

import gui.DatData;
import gui.DictionaryData;
import gui.Document;
import gui.SecData;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.JOptionPane;
import loader.LoaderRASC;

public class SaveRASC {
    public static boolean saveRASC(Document doc, String filename) {
        Object[] options;
        OutputStreamWriter w;
        Exception e = null;
        try {
            FileOutputStream datOut = new FileOutputStream(LoaderRASC.changeExtension(filename, "DAT"));
            w = new OutputStreamWriter(datOut);
            SaveRASC.saveDAT(doc, w);
            ((Writer)w).close();
            datOut.close();
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There was an error saving the DAT file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
        }
        e = null;
        try {
            FileOutputStream depOut = new FileOutputStream(LoaderRASC.changeExtension(filename, "DEP"));
            w = new OutputStreamWriter(depOut);
            SaveRASC.saveDEP(doc, w);
            ((Writer)w).close();
            depOut.close();
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There was an error saving the DEP file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
        }
        e = null;
        try {
            FileOutputStream dicOut = new FileOutputStream(LoaderRASC.changeExtension(filename, "DIC"));
            w = new OutputStreamWriter(dicOut);
            SaveRASC.saveDIC(doc, w);
            ((Writer)w).close();
            dicOut.close();
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There was an error saving the DIC file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
        }
        e = null;
        try {
            FileOutputStream inpOut = new FileOutputStream(LoaderRASC.changeExtension(filename, "INP"));
            w = new OutputStreamWriter(inpOut);
            SaveRASC.saveINP(doc, w);
            ((Writer)w).close();
            inpOut.close();
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There was an error saving the INP file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
        }
        return true;
    }

    protected static void saveDAT(Document doc, Writer out) throws IOException {
        Iterator secIter = doc.sec.iterator();
        while (secIter.hasNext()) {
            SecData.SectionRow section = (SecData.SectionRow)secIter.next();
            out.write(section.getName());
            Iterator dataIter = section.datData.iterator();
            int i = 0;
            while (dataIter.hasNext()) {
                DatData.DataRow data = (DatData.DataRow)dataIter.next();
                if (data.isIncomplete()) continue;
                String event = "";
                if (data.getBuddy() && i != 0) {
                    event = "-";
                }
                event = String.valueOf(event) + data.getID();
                if (i % 20 == 0) {
                    out.write("\r\n");
                }
                out.write(SaveRASC.fillSpace(event, 4));
                ++i;
            }
            if (i % 20 == 0) {
                out.write("\r\n");
            }
            out.write("-999");
            out.write("\r\n");
        }
        out.write("LAST\r\n");
    }

    protected static void saveDEP(Document doc, Writer out) throws IOException, Exception {
        out.write("DECIMAL DEPTH FILE\r\n");
        Iterator secIter = doc.sec.iterator();
        int numLevels = 0;
        while (secIter.hasNext()) {
            numLevels = 0;
            SecData.SectionRow section = (SecData.SectionRow)secIter.next();
            out.write(String.valueOf(section.getName()) + "\r\n");
            out.write(String.valueOf(section.getUnit()) + SaveRASC.formatFloat(section.getWaterDepth(), 5, 1, true) + SaveRASC.formatFloat(section.getHeightRotTabl(), 7, 1, true) + "\r\n");
            out.write("AUTHOR none\r\n");
            Iterator dataIter = section.datData.iterator();
            boolean wroteSomething = false;
            int i = 0;
            while (dataIter.hasNext()) {
                DatData.DataRow data = (DatData.DataRow)dataIter.next();
                if (data.isIncomplete() || data.getBuddy() && i != 0) continue;
                out.write(SaveRASC.formatFloat(data.getDepth(), 7, 2, true));
                wroteSomething = true;
                ++numLevels;
                if (++i % 9 == 0 && i != 0) {
                    out.write("\r\n");
                    continue;
                }
                out.write(",");
            }
            if (!wroteSomething) {
                out.write("0000.00,\r\n");
            }
            if (i % 9 != 0) {
                out.write("\r\n");
            }
            if (numLevels <= 150) continue;
            Object[] options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There are " + numLevels + " depth levels in " + section.getName() + ". RASC's max is 150. All are saved, but RASC might crash.", "Too many levels.", -1, 3, null, options, options[0]);
        }
        out.write("LAST\r\n");
    }

    protected static void saveDIC(Document doc, Writer out) throws IOException {
        Iterator dicIter = doc.dic.iterator();
        while (dicIter.hasNext()) {
            DictionaryData.DicRow row = (DictionaryData.DicRow)dicIter.next();
            if (row.getID() == -1 || row.getName().length() < 1) continue;
            String name = row.getName();
            if (name.length() > 40) {
                name = name.substring(0, 40);
            }
            String paddedName = name;
            while (paddedName.length() < 41) {
                paddedName = String.valueOf(paddedName) + " ";
            }
            out.write(String.valueOf(paddedName) + row.getID() + "\r\n");
        }
        out.write("LAST\r\n");
    }

    protected static void saveINP(Document doc, Writer out) throws IOException {
        Object[] options;
        int numWells = doc.sec.getRowCount();
        if (numWells > 99) {
            Object[] options2 = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There are " + numWells + " wells. RASC's max is 99. All will be saved, but RASC may crash.", "Too many Wells", -1, 3, null, options2, options2[0]);
            numWells = 99;
        }
        out.write(String.valueOf(SaveRASC.fillSpace("" + numWells, 2)) + SaveRASC.fillSpace("" + doc.wellCutoff, 2) + SaveRASC.fillSpace("" + doc.indicator1, 2) + SaveRASC.fillSpace("" + doc.indicator2, 2) + SaveRASC.fillSpace("" + doc.indicator3, 2) + SaveRASC.fillSpace("" + doc.pairCutoff, 2) + "\r\n");
        String ue = "";
        String mh = "";
        int numUE = 0;
        int numMH = 0;
        Iterator dicIter = doc.dic.iterator();
        while (dicIter.hasNext()) {
            DictionaryData.DicRow row = (DictionaryData.DicRow)dicIter.next();
            if (row.getUE()) {
                if (numUE < 20) {
                    ue = String.valueOf(ue) + SaveRASC.fillSpace("" + row.getID(), 4);
                }
                ++numUE;
            }
            if (!row.getMH()) continue;
            if (numMH < 20) {
                mh = String.valueOf(mh) + SaveRASC.fillSpace("" + row.getID(), 4);
            }
            ++numMH;
        }
        out.write(String.valueOf(ue) + "\r\n");
        out.write(String.valueOf(mh) + "\r\n");
        if (numUE > 20) {
            options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "You have selected " + numUE + " unique events. RASC's max is 20. Only the first 20 were saved.", "Too many Unique Events", -1, 3, null, options, options[0]);
        }
        if (numMH > 20) {
            options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "You have selected " + numMH + " marker horizons. RASC's max is 20. Only the first 20 were saved.", "Too many Marker Horizons", -1, 3, null, options, options[0]);
        }
    }

    protected static String fillSpace(String s, int width) {
        String ret = s;
        while (ret.length() < width) {
            ret = " " + ret;
        }
        return ret;
    }

    public static String formatFloat(float f, int width, int fracDigits, boolean fillSpaces) throws Exception {
        if (f < 0.0f) {
            throw new Exception("\"" + f + "\" where only positive numbers are allowed.");
        }
        int intDigits = width - fracDigits - 1;
        while ((double)f > Math.pow(10.0, intDigits) && fracDigits > 0) {
            ++intDigits;
            --fracDigits;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(fracDigits);
        nf.setMinimumFractionDigits(fracDigits);
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(intDigits);
        String s = nf.format(f);
        if (fillSpaces) {
            return SaveRASC.fillSpace(s, width);
        }
        return s;
    }
}

